%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%  Symbolic Laplacian in cylindrical coordinates

% This function computes div(grad(f)) in Cylindrical coordinate system and
% returns symbolic expression

function F = LaplaceCyl(f)
syms r phi z 

Fr = diff(r*diff(f,r),r);
Fp = diff(f,phi,2);
Fz = diff(f,z,2);
F = 1/r*Fr + 1/r^2*Fp + Fz;